<?php

namespace ElementorPro\Modules\Posts\Skins;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Skin_Gremmos extends Skin_Cards
{


    public function get_id()
    {
        return 'gremmos';
    }

    public function get_title()
    {
        return __('Gremmos', 'elementor-pro');
    }

//    public function register_design_card_controls(){
//        parent::register_design_card_controls();
//    }


    protected function render_post()
    {
        $this->render_post_header();
        $this->render_thumbnail();
        $this->render_text_header();
        $this->render_title();
        if ($this->get_instance_value('show_badge')) {
            $this->render_badge();
        }
        $this->render_excerpt();
        $this->render_read_more();
        $this->render_text_footer();
        $this->render_meta_data();
        $this->render_post_footer();
    }

    protected function render_badge()
    {
        $taxonomy = $this->get_instance_value('badge_taxonomy');
        if (empty($taxonomy)) {
            return;
        }

        $terms = get_the_terms(get_the_ID(), $taxonomy);
        if (!$terms) {
            return;
        }
        ?>
        <div class="elementor-post__badges">
            <?php foreach ($terms as $term): ?>
                <div class="elementor-post__badge"><?php echo $term->name; ?></div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}
